<?php

/*
Plugin Name: AutoInvoice
Plugin URI: http://wooinvoice.dk
Description: Setups everything needed for automatic creation of invoices in Dinero.
Version: 1.0.1
Author: tvup
Author URI: http://wooinvoice.dk/vilkaar/
License: GPLv2 or later
*/

/*
Woo Invoice is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
any later version.

Woo Invoice is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Woo Invoice. If not, see http://wooinvoice.dk/plugin-license.
*/
add_action('admin_menu', 'AutoInvoice_plugin_setup_menu' );

function AutoInvoice_plugin_setup_menu(){
	add_menu_page( 'AutoInvoice setup', 'AutoInvoice', 'manage_options', 'AutoInvoice', 'print_admin_page_content' );
}

function print_admin_page_content(){
	setcookie( "wooinvoice_server_response", '', time()-3600 );
	echo '<h1>AutoInvoice connect</h1>' . PHP_EOL;
	echo '<p>First connection has been performed: <b>'.(get_option('AutoInvoice_is_connected') == 1 ? 'true' : 'false').'</b></p>' . PHP_EOL;
	echo '<p>Login below to set/update configuration for automatic invoice creation</p>'. PHP_EOL;
	$message = $_COOKIE[ 'wooinvoice_server_response' ];
	if ( !empty($message) ) {
		echo '<p><b>'.$message.'</b></p>'. PHP_EOL;
	}
    echo '<form method="POST" action="' . admin_url( 'admin-post.php' ) . '">'. PHP_EOL;
    echo '<input type="hidden" name="action" value="wifu1001" />'. PHP_EOL;
    echo '<input type="email" name="email" placeholder="Email"/><br/>'. PHP_EOL;
    echo '<input type="password" name="password" placeholder="Enter your password"/><br/>'. PHP_EOL;
    echo '<input type="submit" value="Login"/>'. PHP_EOL;
    echo '</form>'. PHP_EOL;
}

add_action( 'admin_post_wifu1001', 'wifu1001_admin_action' );
function wifu1001_admin_action()
{
	if ( isset( $_POST['email'] ) && isset( $_POST['password'] ) ) {

		$body = array(
			'email'   => sanitize_email( $_POST['email'] ),
			'password'    => sanitize_text_field( $_POST['password'] ),
			'shop_name' => get_bloginfo( 'name' ),
			'url' => get_bloginfo( 'url' ),
		);

		$args = array(
			'body'        => $body,
			'timeout'     => '5',
			'redirection' => '5',
			'httpversion' => '1.0',
			'blocking'    => true,
			'headers'     => array(),
			'cookies'     => array(),
		);

		$response = wp_remote_post( 'https://wooinvoice.dk/api/plugin-login', $args );
        $responseCode = wp_remote_retrieve_response_code( $response );
		if(!in_array($responseCode, array(200, 201, 202, 203, 204, 205, 206, 207, 208, 226))) {
			$errorMessage = 'An error occurred while trying to connect to AutoInvoice';
			error_log( $errorMessage );
			setcookie( "wooinvoice_server_response", $errorMessage, time()+30 );
			wp_redirect( $_SERVER['HTTP_REFERER'] );
			exit;
		}
		$body = wp_remote_retrieve_body($response);
		$data = json_decode($body, true);

		$userID = $data['user_id'];
		$shop_id = $data['shop_id'];
		$secret = $data['secret'];
		createOrUpdateWebhook('wooinvoice.order.created', 'order.created', $secret, 'https://mb.wooinvoice.dk/api/woocommerce/v3/'.$userID.'/'.$shop_id.'/new-order', 'active');
		createOrUpdateWebhook('wooinvoice.action.woocommerce_order_status_processing', 'action.woocommerce_order_status_processing', $secret, 'https://mb.wooinvoice.dk/api/woocommerce/v3/'.$userID.'/'.$shop_id.'/order-processing', 'active');
		createOrUpdateWebhook('wooinvoice.action.woocommerce_order_status_completed', 'action.woocommerce_order_status_completed', $secret, 'https://mb.wooinvoice.dk/api/woocommerce/v3/'.$userID.'/'.$shop_id.'/order-completed', 'active');

		$option = get_option('AutoInvoice_is_connected');
        if($option) {
            update_option('AutoInvoice_is_connected', true);
        } else {
            add_option('AutoInvoice_is_connected', true);
        }

	}

	wp_redirect( $_SERVER['HTTP_REFERER'] );
	exit();
}





function createWebhook( $name, $topic, $secret, $deliveryURL, $status ) {
	$webhook = new WC_Webhook();
	$webhook->set_name( $name );
	$webhook->set_topic( $topic );
	$webhook->set_secret( $secret );
	$webhook->set_delivery_url( $deliveryURL );
	$webhook->set_status( $status );
	$webhook->set_api_version('wp_api_v2');
	$save = $webhook->save();

	return $save;
}

function updateWebhook($id, $name, $topic, $secret, $deliveryURL, $status ) {
	$webhook = new WC_Webhook($id);
	$webhook->set_name( $name );
	$webhook->set_topic( $topic );
	$webhook->set_secret( $secret );
	$webhook->set_delivery_url( $deliveryURL );
	$webhook->set_status( $status );
	$webhook->set_api_version('wp_api_v2');
	$save = $webhook->save();

	return $save;
}

function createOrUpdateWebhook($name, $topic, $secret, $deliveryURL, $status) {
	$data_store = \WC_Data_Store::load( 'webhook' );
    $args['search'] = sanitize_text_field( wp_unslash( $name ) );
	$webhooks   = $data_store->search_webhooks($args);
	if(count($webhooks)==1) {
		updateWebhook($webhooks[0], $name, $topic, $secret, $deliveryURL, $status);
    } else {
        createWebhook($name, $topic, $secret, $deliveryURL, $status);
    }
}
